/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2023.5.5
* Description : 配置字中使能外部复位功能,通过向PB3脚输入低电平来触发外部复位
*               若在PB3口输入高电平或者不加入任何状态,PB4将一直输出当前系统时钟
*               当往PB3口输入低电平时,发生外部管脚复位,PB4不在正常输出当前系统时钟
*               注：使用PB3外部复位引脚时，需接外部上拉;
***********************************************************************************************/

#include "AD18F08.h"

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  禁止LVR
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位

*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_ON_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );
//---------配置字 RESETE 可选--------------
//_RESETE_OFF_2L        禁止外部管脚复位
//_RESETE_ON_2L         使能外部管脚复位
//------------------------

void main(void)
{

	TRISB3 = 1;     //PB3(复位脚)设置为输入
	PB3PU = 0;      //PB3上拉打开
	TRISB4 = 0;     //PB4设置为输出
    CKOE0  = 1;     //使能CKOE0  PB4输出当前系统时钟

    while(1)
	{

	}
}

//高优先级中断服务函数
void interrupt ISR_h (void)
{

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{

}

